package ru.yandex.travel.api.endpoints.booking_flow.req_rsp;

import java.util.List;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;

import ru.yandex.travel.api.endpoints.booking_flow.model.promo.AppliedPromoCampaignsDto;
import ru.yandex.travel.api.endpoints.booking_flow.validation.IpAddress;

@Data
public class EstimateDiscountReqV1 {
    @NotBlank
    private String token;
    private String label;
    @NotBlank
    private String checksum;
    @IpAddress
    private String customerIp;
    private String customerUserAgent;
    private String customerLogin;
    @NotBlank
    private String customerYandexUid;
    @NotNull
    private String customerPassportId;
    @NotEmpty
    private String sessionKey;
    @Min(0)
    @Max(10)
    private int selectedBedGroupIndex;

    // can be empty in case of just plus point discounts, see appliedPromoCampaigns
    @NotNull
    private List<String> promoCodes;

    private AppliedPromoCampaignsDto appliedPromoCampaigns;
}
