package ru.yandex.travel.api.endpoints.booking_flow.req_rsp;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Builder;
import lombok.Value;
import org.javamoney.moneta.Money;

import ru.yandex.travel.api.endpoints.booking_flow.model.PaymentScheduleDto;
import ru.yandex.travel.api.endpoints.booking_flow.model.PromoCodeApplicationResult;
import ru.yandex.travel.api.endpoints.booking_flow.model.promo.PromoCampaignsDto;

@Value
@Builder
public class EstimateDiscountRspV1 {

    private List<PromoCodeApplicationResult> codeApplicationResults;

    private Money originalAmount;
    private Money discountedAmount;
    private Money discountAmount;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer discountPlusPoints;
    private PromoCampaignsDto promoCampaigns;
    private PaymentScheduleDto deferredPaymentSchedule;
}
