package ru.yandex.travel.api.endpoints.booking_flow.validation;

import java.util.List;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.springframework.util.CollectionUtils;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.travel.api.endpoints.booking_flow.model.Guest;

/**
 * Either both first name and last name should be filled or both fields should be remained empty.
 */
public class GuestNameValidator implements ConstraintValidator<GuestNames, List<Guest>> {
    @Override
    public boolean isValid(List<Guest> value, ConstraintValidatorContext context) {
        if (CollectionUtils.isEmpty(value)) {
            return false;
        }
        if (value.get(0).isEmpty()) {
            return false;
        }
        return value.stream()
                .allMatch(this::isValid);
    }

    private boolean isValid(Guest value) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        return !StringUtils.isBlank(value.getFirstName()) && !StringUtils.isBlank(value.getLastName());
    }
}
