package ru.yandex.travel.api.endpoints.booking_flow.validation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.apache.logging.log4j.util.Strings;

public class IpAddressValidator implements ConstraintValidator<IpAddress, String> {
    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (Strings.isBlank(value)) {
            return false;
        }
        try {
            ru.yandex.misc.ip.IpAddress.parse(value);
            return true;
        } catch (IllegalArgumentException ex) {
            return false;
        }
    }
}
