package ru.yandex.travel.api.endpoints.booking_flow.validation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.apache.logging.log4j.util.Strings;

public class PhoneValidator implements ConstraintValidator<Phone, String> {
    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (Strings.isBlank(value)) {
            return false;
        }
        String stripped = value.replaceAll("[^\\d]", "");
        return (stripped.length() >= 10 && stripped.length() <= 80);
    }
}
