package ru.yandex.travel.api.endpoints.buses.req_rsp;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;

import ru.yandex.travel.api.infrastucture.ParamName;

@ApiModel(value = "Запрос направлений автобусов/лендинг")
@Data
@Valid
public class BusDirectionReqV1 {
    @ParamName("fromSlug")
    @ApiParam(name = "from_slug", value = "Slug региона откуда")
    @NotNull
    private String fromSlug;

    @ParamName("toSlug")
    @ApiParam(name = "to_slug", value = "Slug региона куда")
    @NotNull
    private String toSlug;
}
