package ru.yandex.travel.api.endpoints.buses.req_rsp;

import java.time.LocalDateTime;
import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;

import ru.yandex.travel.api.models.common.Price;
import ru.yandex.travel.api.models.crosslinks.CrosslinksHotelsBlockData;

@ApiModel(value = "Ответ направлений автобусов/лендинг")
@Data
@AllArgsConstructor
public class BusDirectionRspV1 {
    private BusesContext context;
    private List<TDirectionPageBlock> blocks;

    public interface TDirectionPageBlock {
        BlockType getType();
    }

    public interface TDirectionPageBlockData {
        String getTitle();
    }

    @Getter
    @AllArgsConstructor
    public enum BlockType {
        CROSS_SALE_HOTELS_BLOCK("ICrossSaleHotelsBlock"),
        BUSES_CROSSLINK("IBusesCrossLinksBlock"),
        BUSES_SEGMENTS("IBusesSegmentsBlock")
        ;

        @JsonValue
        private final String typeName;
    }

    @Data
    @AllArgsConstructor
    public static class BusesCrossLinksBlock implements TDirectionPageBlock {
        public BlockType getType() {
            return BlockType.BUSES_CROSSLINK;
        }
        private BusesCrossLinksBlockData data;
    }

    @Data
    @AllArgsConstructor
    public static class BusesCrossLinksBlockData implements TDirectionPageBlockData {
        @JsonInclude(JsonInclude.Include.NON_NULL)
        private String title;
        private List<CrossLink> crossLinks;
    }

    @Data
    @AllArgsConstructor
    public static class BusesSegmentsBlock implements TDirectionPageBlock {
        public BlockType getType() {
            return BlockType.BUSES_SEGMENTS;
        }
        private BusesSegmentsBlockData data;
    }

    @Data
    @AllArgsConstructor
    public static class BusesSegmentsBlockData implements TDirectionPageBlockData {
        @JsonInclude(JsonInclude.Include.NON_NULL)
        private String title;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private String when;

        private List<BusesSegment> segments;
    }

    @Data
    @AllArgsConstructor
    public static class CrossSaleHotelsBlock implements TDirectionPageBlock {
        public BlockType getType() {
            return BlockType.CROSS_SALE_HOTELS_BLOCK;
        }
        private CrosslinksHotelsBlockData data;
    }

    @Data
    public static class BusesSegment {
        private String id;
        private String carrierCode;
        private LocalDateTime departureTime;
        private Integer freeSeats;
        private Price price;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        @Nullable
        private LocalDateTime arrivalTime;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private String carrierName;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private Long duration;

        private BusesApiPoint from;
        private BusesApiPoint to;
    }

    @Data
    public static class BusesApiPoint {
        private String title;
        private String timezone;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private String fullTitle;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private Coordinates coordinates;
    }

    @Data
    @AllArgsConstructor
    public static class Coordinates {
        private Double latitude;
        private Double longitude;
    }

    @Data
    public static class BusesContext {
        private ContextPoint to;
        private ContextPoint from;
        private String[] errors;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        private Double distance;
    }

    @Data
    public static class ContextPoint {
        private ContextPointCountry country;
        private String key;
        private ContextPointRegion region;
        private ContextPointSettlement settlement;
        private String slug;
        private String timezone;
        private ContextPointLinguistics title;
    }

    @Data
    public static class ContextPointRegion {
        private String title;
    }

    @Data
    public static class ContextPointCountry {
        private String title;
        private String code;
    }

    @Data
    public static class ContextPointSettlement {
        private String title;
    }

    @Data
    public static class ContextPointLinguistics {
        private String accusativeCase;
        private String genitiveCase;
        private String nominativeCase;
        private String locativeCase;
    }

    @Data
    public static class CrossLink {
        private String toKey;
        private String toSlug;
        private String toTitle;
        private String fromKey;
        private String fromSlug;
        private String fromTitle;
    }
}
