package ru.yandex.travel.api.endpoints.cpa.req_rsp;

import java.time.LocalDateTime;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import ru.yandex.travel.api.infrastucture.ParamName;

@Data
@NoArgsConstructor
@ApiModel(value = "Запрос сложных заказов для CPA")
public class CpaBoyOrdersReq {
    @ParamName("updated_at_from_utc")
    @ApiParam(name = "updated_at_from_utc")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
    @NotNull
    private LocalDateTime updatedAtFromUtc;

    @ParamName("updated_at_to_utc")
    @ApiParam(name = "updated_at_to_utc")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
    private LocalDateTime updatedAtToUtc;

    @ParamName("limit")
    @ApiParam("limit")
    @Positive
    private int limit;
}
