package ru.yandex.travel.api.endpoints.cpa.req_rsp;

import java.time.LocalDateTime;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import ru.yandex.travel.api.infrastucture.ParamName;
import ru.yandex.travel.api.models.cpa.CpaOrderType;

@Data
@NoArgsConstructor
@ApiModel(value = "Запрос состояний заказов для CPA V2")
public class CpaOrderSnapshotReqV2 {

    @ParamName("updated_at_from_utc")
    @ApiParam(name = "updated_at_from_utc")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
    @NotNull
    private LocalDateTime updatedAtFromUtc;

    @ParamName("updated_at_to_utc")
    @ApiParam(name = "updated_at_to_utc")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
    private LocalDateTime updatedAtToUtc;

    @ParamName("order_type")
    @ApiParam("order_type")
    @NotNull
    private CpaOrderType orderType;

    @ParamName("limit")
    @ApiParam("limit")
    @Positive
    private int limit;

    @ParamName("return_extended_status")
    @ApiParam("return_extended_status")
    private Boolean returnExtendedStatus;

    @ParamName("add_personal_data")
    @ApiParam("add_personal_data")
    private boolean addPersonalData = false;
}
