package ru.yandex.travel.api.endpoints.generic_booking_flow.model;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.orders.commons.proto.ECancellationReason;

@Getter
@RequiredArgsConstructor
public enum CancellationReason {
    EXPIRED(ECancellationReason.CR_EXPIRED),
    RESERVATION_FAILED(ECancellationReason.CR_RESERVATION_FAILED),
    CONFIRMATION_FAILED(ECancellationReason.CR_CONFIRMATION_FAILED),
    USER_CANCELLED(ECancellationReason.CR_USER_CANCELLED);

    private final ECancellationReason proto;

    public static final EnumIndex<ECancellationReason, CancellationReason> BY_PROTO =
            EnumIndex.create(CancellationReason.class, CancellationReason::getProto);
}
