package ru.yandex.travel.api.endpoints.generic_booking_flow.model;

import java.util.List;

import lombok.Builder;
import lombok.Data;
import org.javamoney.moneta.Money;

import ru.yandex.travel.api.endpoints.booking_flow.model.CurrentPaymentDto;
import ru.yandex.travel.api.endpoints.booking_flow.model.NextPaymentDto;
import ru.yandex.travel.api.endpoints.booking_flow.model.PaymentErrorCode;
import ru.yandex.travel.api.endpoints.booking_flow.model.PaymentErrorDto;

@Data
@Builder
public class PaymentDTO {
    private CurrentPaymentDto current;
    private NextPaymentDto next;
    private PaymentErrorDto error;
    private List<PaymentReceiptItem> receipts;
    private boolean mayBeStarted;
    private boolean mayBeCancelled;
    private boolean usesDeferredPayments;
    private Money amountPaid;


    public String getPaymentUrl() {
        if (current == null) {
            return null;
        } else {
            return current.getPaymentUrl();
        }
    }

    public PaymentErrorCode getErrorInfo() {
        if (error == null) {
            return null;
        } else {
            return error.getCode();
        }
    }
}
