package ru.yandex.travel.api.endpoints.generic_booking_flow.model;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.proto.EFiscalReceiptType;

@Getter
@RequiredArgsConstructor
public enum PaymentReceiptItemType {
    ACQUIRE(EFiscalReceiptType.FRT_ACQUIRE),
    CLEAR(EFiscalReceiptType.FRT_CLEAR),
    REFUND(EFiscalReceiptType.FRT_REFUND);

    private final EFiscalReceiptType proto;

    public static final EnumIndex<EFiscalReceiptType, PaymentReceiptItemType> BY_PROTO =
            EnumIndex.create(PaymentReceiptItemType.class, PaymentReceiptItemType::getProto);
}
