package ru.yandex.travel.api.endpoints.generic_booking_flow.model.refund;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.orders.proto.ERefundPartState;

@RequiredArgsConstructor
public enum RefundPartState {
    DISABLED(ERefundPartState.RPS_DISABLED),
    ENABLED(ERefundPartState.RPS_ENABLED),
    REFUNDED(ERefundPartState.RPS_REFUNDED),
    DEPENDENT(ERefundPartState.RPS_DEPENDENT),
    OFFLINE_ENABLED(ERefundPartState.RPS_OFFLINE_ENABLED);

    private final ERefundPartState protoValue;

    public final static EnumIndex<ERefundPartState, RefundPartState> BY_PROTO =
            EnumIndex.create(RefundPartState.class, eValue -> eValue.protoValue);
}
