package ru.yandex.travel.api.endpoints.generic_booking_flow.model.refund;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.orders.proto.ERefundPartType;

@RequiredArgsConstructor
public enum RefundPartType {
    ORDER(ERefundPartType.RPT_ORDER),
    SERVICE(ERefundPartType.RPT_SERVICE),
    SERVICE_PART(ERefundPartType.RPT_SERVICE_PART);

    private final ERefundPartType protoValue;

    public final static EnumIndex<ERefundPartType, RefundPartType> BY_PROTO =
            EnumIndex.create(RefundPartType.class, eValue -> eValue.protoValue);
}
