package ru.yandex.travel.api.endpoints.generic_booking_flow.model.refund;

import java.util.Map;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.orders.proto.EOrderRefundType;

@RequiredArgsConstructor
public enum RefundType {
    TRAIN_OFFICE_REFUND,
    TRAIN_INSURANCE_AUTO_RETURN,
    USER_REFUND;

    public final static Map<EOrderRefundType, RefundType> BY_PROTO = Map.of(
            EOrderRefundType.RT_TRAIN_USER_REFUND, RefundType.USER_REFUND,
            EOrderRefundType.RT_GENERIC_USER_REFUND, RefundType.USER_REFUND,
            EOrderRefundType.RT_TRAIN_OFFICE_REFUND, RefundType.TRAIN_OFFICE_REFUND,
            EOrderRefundType.RT_TRAIN_INSURANCE_AUTO_RETURN, RefundType.TRAIN_INSURANCE_AUTO_RETURN
    );
}
