package ru.yandex.travel.api.endpoints.generic_booking_flow.model.suburban;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import lombok.extern.jackson.Jacksonized;

import ru.yandex.travel.suburban.model.AeroexpressReservation;


@Value
@Builder
@Jacksonized
@AllArgsConstructor
public class AeroexpressServiceInfoDTO {
    private String ticketUrl;
    private String tariff;
    private String stDepart;
    private String tripDate;
    private String validUntil;
    private Integer menuId;

    public AeroexpressServiceInfoDTO(AeroexpressReservation reservation) {
        ticketUrl = reservation.getTicketUrl();
        tariff = reservation.getTariff();
        stDepart = reservation.getStDepart();
        tripDate = reservation.getTripDate();
        validUntil = reservation.getValidUntil();
        menuId = reservation.getMenuId();
    }
}
