package ru.yandex.travel.api.endpoints.generic_booking_flow.model.suburban;

import java.math.BigDecimal;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Builder;
import lombok.Data;
import lombok.extern.jackson.Jacksonized;

import ru.yandex.travel.commons.jackson.CommonJsonUtils;
import ru.yandex.travel.suburban.partners.SuburbanCarrier;
import ru.yandex.travel.suburban.partners.SuburbanProvider;

@Data
@Builder
@Jacksonized
public class CreateSuburbanServiceData {
    @NotNull
    private SuburbanProvider provider;
    @NotNull
    private SuburbanCarrier carrierPartner;

    @NotNull
    private Integer stationFromId;
    @NotNull
    private Integer stationToId;
    @NotNull
    private BigDecimal price;

    private JsonNode providerBookData;

    private String testContextToken;

    private static final ObjectMapper objMapper = CommonJsonUtils.createCommonObjectMapper();

    @JsonIgnore
    public MovistaBookData getMovistaBookData() {
        if (provider == SuburbanProvider.MOVISTA) {
            return objMapper.convertValue(providerBookData, MovistaBookData.class);
        } else {
            throw new RuntimeException(
                    String.format("Movista provider must be set to get MovistaBookData, but got %s", provider));
        }
    }

    @JsonIgnore
    public ImBookData getImBookData() {
        if (provider == SuburbanProvider.IM) {
            return objMapper.convertValue(providerBookData, ImBookData.class);
        } else {
            throw new RuntimeException(
                    String.format("IM provider must be set to get ImBookData, but got %s", provider));
        }
    }

    @JsonIgnore
    public AeroexpressBookData getAeroexpressBookData() {
        if (provider == SuburbanProvider.AEROEXPRESS) {
            return objMapper.convertValue(providerBookData, AeroexpressBookData.class);
        } else {
            throw new RuntimeException(
                    String.format("Aeroexpress provider must be set to get AeroexpressBookData, but got %s", provider));
        }
    }
}
