package ru.yandex.travel.api.endpoints.generic_booking_flow.model.suburban;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import lombok.Builder;
import lombok.Data;
import lombok.extern.jackson.Jacksonized;

import ru.yandex.travel.suburban.model.SuburbanReservation;
import ru.yandex.travel.suburban.model.SuburbanTicketFlow;
import ru.yandex.travel.suburban.model.WicketDevice;
import ru.yandex.travel.suburban.partners.SuburbanCarrier;
import ru.yandex.travel.suburban.partners.SuburbanProvider;
import ru.yandex.travel.suburban.partners.SuburbanTicketBarcodePreset;

@Data
@Builder
@Jacksonized
public class SuburbanServiceInfoDTO {
    private SuburbanProvider provider;
    private SuburbanCarrier carrierPartner;
    private SuburbanTicketFlow flow;
    private SuburbanTicketBarcodePreset barcodePreset;

    private LocalDateTime date;
    private Integer stationFromId;
    private Integer stationToId;

    private BigDecimal price;

    private String partnerOrderId;
    private String ticketNumber;
    private String ticketBody;
    private WicketDevice wicket;
    private AeroexpressServiceInfoDTO aeroexpressInfo;

    private Error error;

    @Data
    @Jacksonized
    @Builder
    public static class Error {
        String message;

        public static Error fromSuburbanReservationError(SuburbanReservation.Error error) {
            if (error != null) {
                return new Error(error.getMessage());
            }
            return null;
        }
    }
}
