package ru.yandex.travel.api.endpoints.generic_booking_flow.model.train;

import java.time.LocalDate;

import lombok.AccessLevel;
import lombok.Data;
import lombok.Setter;
import org.javamoney.moneta.Money;

import ru.yandex.travel.api.endpoints.generic_booking_flow.model.refund.RefundPartInfo;
import ru.yandex.travel.api.models.train.Insurance;
import ru.yandex.travel.api.models.train.Ticket;
import ru.yandex.travel.train.model.DocumentType;
import ru.yandex.travel.train.model.Sex;

import static ru.yandex.travel.api.models.train.TrainOrderMaps.DOCUMENT_TYPE_TO_STR;
import static ru.yandex.travel.api.models.train.TrainOrderMaps.SEX_TO_STR;

@Data
public class PassengerDTO {
    private Ticket ticket;
    private String docId;
    @Setter(AccessLevel.NONE)
    private String docType;
    private String citizenship;
    private String firstName;
    private String lastName;
    private String patronymic;
    private int age;
    private LocalDate birthDate;
    @Setter(AccessLevel.NONE)
    private String sex;
    private Integer customerId;
    private Insurance insurance;
    private boolean nonRefundableTariff;

    private RefundPartInfo refundPartInfo;
    private Money total;

    public void setDocType(DocumentType value) {
        docType = DOCUMENT_TYPE_TO_STR.get(value);
    }

    public void setSex(Sex value) {
        sex = SEX_TO_STR.get(value);
    }
}
