package ru.yandex.travel.api.endpoints.generic_booking_flow.model.train;

import java.time.Instant;
import java.util.List;

import lombok.Data;

import ru.yandex.travel.api.models.train.Direction;
import ru.yandex.travel.api.models.train.ErrorInfo;
import ru.yandex.travel.api.models.train.InsuranceStatus;
import ru.yandex.travel.api.models.train.Station;
import ru.yandex.travel.api.models.train.TrainInfo;
import ru.yandex.travel.api.models.train.WarningInfo;

@Data
public class TrainServiceInfoDTO {
    private ErrorInfo error;
    private InsuranceStatus insuranceStatus;
    private Direction direction;
    private int segmentIndex;

    private Integer partnerOrderId;
    private String reservationNumber;
    private Station stationFrom;
    private Station stationTo;
    private TrainInfo trainInfo;
    private String carType;
    private String compartmentGender;
    private Instant arrival;
    private Instant departure;
    private String partner;
    private String carNumber;
    private String specialNotice;
    private List<WarningInfo> warnings;
    private boolean twoStorey;
    private String coachOwner;
    private String companyTitle;
    private List<PassengerDTO> passengers;
    private String downloadBlankToken;

    //  future
    private boolean rebookingAvailable;
}
