package ru.yandex.travel.api.endpoints.generic_booking_flow.req_rsp;

import java.util.List;
import java.util.UUID;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Data;

import ru.yandex.travel.api.endpoints.generic_booking_flow.model.ContactInfoDTO;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.CreateHotelServiceData;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.CreateOrderUserInfo;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.CreateTrainServiceData;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.suburban.CreateSuburbanServiceData;
import ru.yandex.travel.api.spec.buses.CreateBusesServiceParams;

@Data
public class CreateGenericOrderReqV1 {
    @NotEmpty
    private UUID deduplicationKey;
    @NotEmpty
    private String label;
    @Valid
    private List<CreateHotelServiceData> hotelServices;
    @Valid
    private List<CreateTrainServiceData> trainServices;
    @Valid
    private List<CreateSuburbanServiceData> suburbanServices;
    @Valid
    private List<CreateBusesServiceParams> busesServices;
    @Valid
    private ContactInfoDTO contactInfo;
    @NotNull
    @Valid
    private CreateOrderUserInfo userInfo;

    private List<String> promoCodes;
    private String paymentTestContextToken;
    @NotNull
    private JsonNode orderHistory;
}
