package ru.yandex.travel.api.endpoints.generic_booking_flow.req_rsp;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

import lombok.Data;

import ru.yandex.travel.api.endpoints.booking_flow.model.OrderPriceInfo;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.CancellationReason;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.ContactInfoDTO;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.GenericOrderState;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.PaymentDTO;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.ServiceDTO;
import ru.yandex.travel.api.endpoints.generic_booking_flow.model.refund.RefundPartInfo;
import ru.yandex.travel.komod.trips.common.TripIdSetter;
import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;

@Data
public class GetGenericOrderRspV1 implements TripIdSetter {
    private UUID id;
    private String prettyId;
    private GenericOrderState state;
    private CancellationReason cancellationReason;
    private EDisplayOrderState displayState;
    private Instant expiresAt;
    private Instant servicedAt;

    private List<ServiceDTO> services;

    private OrderPriceInfo orderPriceInfo;
    private PaymentDTO payment;

    private ContactInfoDTO contactInfo;

    private RefundPartInfo refundPartInfo;

    private Instant reloadOrderAt;

    private UUID tripId;
}
