package ru.yandex.travel.api.endpoints.hotel_connection_status;

import io.grpc.StatusRuntimeException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

import ru.yandex.travel.api.endpoints.hotel_connection_status.req_rsp.GetConnectionStatusReqV1;
import ru.yandex.travel.api.endpoints.hotel_connection_status.req_rsp.GetConnectionStatusRspV1;
import ru.yandex.travel.api.exceptions.GrpcError;
import ru.yandex.travel.api.infrastucture.BindFromQuery;
import ru.yandex.travel.api.infrastucture.ResponseProcessor;

@RestController
@RequestMapping("/api/hotel_connection")
@Api(value = "HotelConnectionStatus", description = "Hotel Connection Status")
@RequiredArgsConstructor
public class HotelConnectionStatusController {
    @ExceptionHandler(IllegalArgumentException.class)
    @ResponseStatus(HttpStatus.BAD_REQUEST)
    public ResponseEntity<String> handleIllegalArgumentException(IllegalArgumentException e) {
        return ResponseEntity.badRequest().contentType(MediaType.TEXT_PLAIN).body(e.getMessage());
    }

    @ExceptionHandler(StatusRuntimeException.class)
    public ResponseEntity<GrpcError> handleGrpcErrors(StatusRuntimeException ex) {
        GrpcError error = GrpcError.fromGrpcStatusRuntimeException(ex);
        return ResponseEntity.status(error.getStatus()).contentType(MediaType.APPLICATION_JSON).body(error);
    }

    private final ResponseProcessor responseProcessor;

    private final HotelConnectionStatusImpl impl;

    @RequestMapping(value = {"/v1/get_status"}, method = RequestMethod.GET, produces = "application/json")
    @ApiOperation(value = "Статус подключения отеля")
    public DeferredResult<GetConnectionStatusRspV1> getHotelConnectionStatusByPermalink(
            @Validated @BindFromQuery GetConnectionStatusReqV1 req) {
        return responseProcessor.replyWithFuture("GetHotelConnectionStatusV1", () -> impl.getHotelConnectionStatus(req));
    }
}
