package ru.yandex.travel.api.endpoints.hotel_connection_status;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.concurrent.CompletableFuture;

import com.google.common.base.Strings;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Service;

import ru.yandex.travel.api.config.hotels.administrator.AdministratorAdminInterfaceProvider;
import ru.yandex.travel.api.endpoints.hotel_connection_status.req_rsp.GetConnectionStatusReqV1;
import ru.yandex.travel.api.endpoints.hotel_connection_status.req_rsp.GetConnectionStatusRspV1;
import ru.yandex.travel.api.endpoints.hotel_connection_status.req_rsp.HotelConnectionPartner;
import ru.yandex.travel.api.endpoints.hotel_connection_status.req_rsp.HotelConnectionState;
import ru.yandex.travel.commons.concurrent.FutureUtils;
import ru.yandex.travel.commons.proto.ProtoUtils;
import ru.yandex.travel.hotels.administrator.grpc.proto.EHotelStatus;
import ru.yandex.travel.hotels.administrator.grpc.proto.THotelStatusByPermalinkReq;
import ru.yandex.travel.hotels.proto.EPartnerId;

@Service
@RequiredArgsConstructor
@EnableConfigurationProperties(HotelConnectionStatusProperties.class)
public class HotelConnectionStatusImpl {

    private final AdministratorAdminInterfaceProvider provider;

    private final HotelConnectionStatusProperties hotelConnectionStatusProperties;

//    private final static String

    public CompletableFuture<GetConnectionStatusRspV1> getHotelConnectionStatus(GetConnectionStatusReqV1 req) {


        return FutureUtils.buildCompletableFuture(
                provider.provideInterface().hotelStatusByPermalink(THotelStatusByPermalinkReq.newBuilder()
                        .setPermalink(req.getPermalink())
                        .build())
        ).thenApply(
                grpcRsp -> {
                    GetConnectionStatusRspV1 rsp = new GetConnectionStatusRspV1();
                    if (grpcRsp.getHotelStatus() == EHotelStatus.H_NOT_FOUND) {
                        rsp.setStatus(HotelConnectionState.NOT_CONNECTED);
                        rsp.setAdditionalInfoUrl(hotelConnectionStatusProperties.getPromoUrl());
                    } else {
                        rsp.setStatus(HotelConnectionState.FROM_PROTO.getByValue(grpcRsp.getHotelStatus()));
                        rsp.setConnectionPartner(HotelConnectionPartner.BY_EPARTNER_ID.getByValue(grpcRsp.getPartnerId()));
                        rsp.setAgreementId(Strings.emptyToNull(grpcRsp.getAgreementId()));
                        rsp.setOriginalId(Strings.emptyToNull(grpcRsp.getHotelCode()));
                        if (grpcRsp.hasAgreementFrom()) {
                            rsp.setAgreementDate(
                                    LocalDate.ofInstant(
                                            ProtoUtils.toInstant(grpcRsp.getAgreementFrom()),
                                            ZoneId.of("Europe/Moscow")
                                    )
                            );
                        }
                        //TODO(mbobrov): logic here
                        if (grpcRsp.getPartnerId() == EPartnerId.PI_TRAVELLINE) {
                            rsp.setAdditionalInfoUrl(hotelConnectionStatusProperties.getTravelline().getPersonalAccountUrl());
                            rsp.setPartnerHelpUrl(hotelConnectionStatusProperties.getTravelline().getHelpUrl());
                        } else if (grpcRsp.getPartnerId() == EPartnerId.PI_BNOVO) {
                            rsp.setAdditionalInfoUrl(hotelConnectionStatusProperties.getBnovo().getPersonalAccountUrl());
                            rsp.setPartnerHelpUrl(hotelConnectionStatusProperties.getBnovo().getHelpUrl());
                        }
                    }
                    return rsp;
                }
        );
    }
}
