package ru.yandex.travel.api.endpoints.hotel_connection_status;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

@Data
@ConfigurationProperties(prefix = "hotel-connection-status", ignoreUnknownFields = false)
public class HotelConnectionStatusProperties {

    @Data
    public static class PartnerUrls {
        @NotNull
        private String helpUrl;
        @NotNull
        private String personalAccountUrl;
    }

    @NotNull
    private String promoUrl;

    @Valid
    private PartnerUrls travelline;

    @Valid
    private PartnerUrls bnovo;
}
