package ru.yandex.travel.api.endpoints.hotel_connection_status.req_rsp;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.hotels.proto.EPartnerId;

@RequiredArgsConstructor
public enum HotelConnectionPartner {

    BNOVO("bnovo", EPartnerId.PI_BNOVO),
    TRAVELLINE("travelline", EPartnerId.PI_TRAVELLINE);

    private final String value;
    private final EPartnerId partnerId;

    public static final EnumIndex<EPartnerId, HotelConnectionPartner> BY_EPARTNER_ID = EnumIndex.create(
            HotelConnectionPartner.class, k -> k.partnerId
    );

    @JsonValue
    public String getValue() {
        return value;
    }
}
