package ru.yandex.travel.api.endpoints.hotel_connection_status.req_rsp;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.hotels.administrator.grpc.proto.EHotelStatus;

@RequiredArgsConstructor
public enum HotelConnectionState {
    NOT_CONNECTED("not_connected", EHotelStatus.H_NOT_FOUND),
    PUBLISHING("publishing", EHotelStatus.H_PUBLISHING),
    PUBLISHED("published", EHotelStatus.H_PUBLISHED),
    UNPUBLISHED("unpublished", EHotelStatus.H_UNPUBLISHED);

    private final String value;

    private final EHotelStatus protoValue;

    public final static EnumIndex<EHotelStatus, HotelConnectionState> FROM_PROTO =
            EnumIndex.create(HotelConnectionState.class, k -> k.protoValue);

    // we use it in read-only mode, so deserialization is not implemented

    @JsonValue
    public String getValue() {
        return value;
    }
}
