package ru.yandex.travel.api.endpoints.hotels_extranet.auth.req_rsp

import com.fasterxml.jackson.annotation.JsonValue
import ru.yandex.travel.hotels.extranet.TApproveAuthRsp
import java.util.EnumMap
import ru.yandex.travel.hotels.extranet.EApproveAuthStatus as EApproveAuthStatusProto

data class ApproveRspV1(
    val status: EApproveAuthStatus
) {
    companion object {
        fun fromProto(response: TApproveAuthRsp): ApproveRspV1 {
            return ApproveRspV1(
                status = EApproveAuthStatus.fromProto(response.status),
            )
        }
    }
}

enum class EApproveAuthStatus(
    @get:JsonValue val value: String,
    val proto: EApproveAuthStatusProto,
) {
    OK("ok", EApproveAuthStatusProto.AAS_OK),

    /** истёк срок действия запроса на авторизацию  */
    EXPIRED_TOKEN("expired_token", EApproveAuthStatusProto.AAS_EXPIRED_TOKEN),

    /** введённый токен невалидный (никогда не запрашивался или был давно удалён из системы)  */
    INVALID_TOKEN("invalid_token", EApproveAuthStatusProto.AAS_INVALID_TOKEN),

    /** токен уже был подтверждён ранее  */
    ALREADY_APPROVED("already_approved", EApproveAuthStatusProto.AAS_ALREADY_APPROVED);

    companion object {
        val mapping = EnumMap<EApproveAuthStatusProto, EApproveAuthStatus>(EApproveAuthStatusProto::class.java).apply {
            values().forEach {
                this[it.proto] = it
            }
        }

        fun fromProto(proto: EApproveAuthStatusProto): EApproveAuthStatus {
            return mapping[proto]!!
        }
    }
}
