package ru.yandex.travel.api.endpoints.hotels_extranet.auth.req_rsp

import ru.yandex.travel.api.endpoints.hotels_extranet.common.Hotel
import ru.yandex.travel.api.services.hotels.slug.HotelSlugService
import ru.yandex.travel.hotels.common.Permalink
import ru.yandex.travel.hotels.extranet.AuthorizedHotel
import ru.yandex.travel.hotels.extranet.TListApprovedRsp
import ru.yandex.travel.hotels.proto.EPartnerId

data class ListApprovedRspV1(
    val hotels: List<Hotel>,
) {
    companion object {
        fun fromProto(response: TListApprovedRsp, slugService: HotelSlugService): ListApprovedRspV1 {
            return ListApprovedRspV1(
                hotels = response.hotelsList.map { it ->
                    Hotel.fromProto(it, slugService)!!
                }.toList()
            )
        }
    }
}
