package ru.yandex.travel.api.endpoints.hotels_extranet.auth.req_rsp

import ru.yandex.travel.hotels.extranet.TRequestAuthReq
import ru.yandex.travel.hotels.proto.EPartnerId
import ru.yandex.travel.hotels.proto.THotelId
import javax.validation.constraints.NotEmpty
import javax.validation.constraints.NotNull

data class RequestReqV1(
    val partnerID: @NotNull EPartnerId,
    val hotelCode: @NotNull @NotEmpty String,
    val email: @NotNull @NotEmpty String,
) {
    fun toProto(): TRequestAuthReq {
        return TRequestAuthReq.newBuilder()
            .setHotelId(THotelId.newBuilder().setPartnerId(this.partnerID).setOriginalId(hotelCode).build())
            .setEmail(this.email)
            .build()
    }
}
