package ru.yandex.travel.api.endpoints.hotels_extranet.auth.req_rsp

import com.fasterxml.jackson.annotation.JsonValue
import ru.yandex.travel.hotels.extranet.TRequestAuthRsp
import java.util.EnumMap
import ru.yandex.travel.hotels.extranet.ERequestAuthStatus as ERequestAuthStatusProto

data class RequestRspV1(
    val status: ERequestAuthStatus
) {
    companion object {
        fun fromProto(response: TRequestAuthRsp): RequestRspV1 {
            return RequestRspV1(
                status = ERequestAuthStatus.fromProto(response.status)
            )
        }
    }
}

enum class ERequestAuthStatus(
    @get:JsonValue val value: String,
    val proto: ERequestAuthStatusProto,
) {

    OK("ok", ERequestAuthStatusProto.RAS_OK),

    /** введенный идентификатор отеля не найден  */
    HOTEL_ID_NOT_FOUND("hotel_id_not_found", ERequestAuthStatusProto.RAS_HOTEL_NOT_FOUND),

    /** идентификатор отеля корректный; но email не совпадает с зарегистрированным  */
    INVALID_EMAIL("invalid_email", ERequestAuthStatusProto.RAS_INVALID_EMAIL),

    /** уже есть активный запрос на авторизацию; ждите email на почту или повторите через 30 минут  */
    ALREADY_REQUESTED("already_requested", ERequestAuthStatusProto.RAS_ALREADY_REQUESTED),

    /** уже есть подтвержденная роль, запрашивать не имеет смысла  */
    ALREADY_APPROVED("already_approved", ERequestAuthStatusProto.RAS_ALREADY_APPROVED);

    companion object {

        val mapping =
            EnumMap<ERequestAuthStatusProto, ERequestAuthStatus>(ERequestAuthStatusProto::class.java).apply {
                values().forEach {
                    this[it.proto] = it
                }
            }

        fun fromProto(proto: ERequestAuthStatusProto): ERequestAuthStatus {
            return mapping[proto]!!
        }
    }
}
