package ru.yandex.travel.api.endpoints.hotels_extranet.common

import ru.yandex.travel.api.services.hotels.slug.HotelSlugService
import ru.yandex.travel.hotels.common.Permalink
import ru.yandex.travel.hotels.extranet.AuthorizedHotel
import ru.yandex.travel.hotels.proto.EPartnerId

data class Hotel(
    val name: String?,
    val partnerId: EPartnerId,
    val hotelCode: String,
    val permalink: Long?,
    var slug: String?,
) {
    companion object {
        fun fromProto(hotel: AuthorizedHotel, slugService: HotelSlugService? = null): Hotel? {
            if (AuthorizedHotel.getDefaultInstance().equals(hotel) || hotel == null) {
                return null
            }
            val permalink = hotel.permalink.takeIf { it != 0L }
            return Hotel(
                name = hotel.title.ifEmpty { null },
                partnerId = hotel.hotelId.partnerId,
                hotelCode = hotel.hotelId.originalId,

                permalink = permalink,
                slug = permalink?.let { slugService?.findMainSlugByPermalink(Permalink.of(it)) },
            )
        }
    }
}
