package ru.yandex.travel.api.endpoints.hotels_extranet.tabledata.req_rsp

import ru.yandex.travel.api.endpoints.hotels_extranet.common.Hotel
import ru.yandex.travel.commons.proto.ProtoUtils
import ru.yandex.travel.hotels.common.orders.Guest
import ru.yandex.travel.hotels.extranet.EBankOrderTransactionTransactionType
import ru.yandex.travel.hotels.extranet.TGetBankOrderInfoDetail
import java.time.Instant
import java.time.LocalDate

data class BankOrderDetail(
    var hotel: Hotel?,

    var orderId: String?,
    var orderPrettyId: String?,

    var transactionType: EBankOrderTransactionTransactionType,

    val firstGuest: Guest?,
    val orderCreatedAt: Instant?,
    val checkInDate: LocalDate?,
    val checkOutDate: LocalDate?,
    val priceBreakdown: BoyOrderInfo.PriceBreakdown,
) {
    companion object {
        fun fromProto(proto: TGetBankOrderInfoDetail): BankOrderDetail {
            val firstGuest = Guest()
            firstGuest.firstName = proto.firstGuest.firstName
            firstGuest.lastName = proto.firstGuest.lastName

            return BankOrderDetail(
                Hotel.fromProto(proto.hotel),
                proto.orderId,
                proto.orderPrettyId,
                proto.transactionType,
                firstGuest,
                ProtoUtils.toInstantFromSafe(proto.orderCreatedAt),
                ProtoUtils.toLocalDateNullable(proto.checkInDate),
                ProtoUtils.toLocalDateNullable(proto.checkOutDate),
                BoyOrderInfo.PriceBreakdown.fromProto(proto.priceBreakdown),
            )
        }
    }
}
