package ru.yandex.travel.api.endpoints.hotels_extranet.tabledata.req_rsp

import ru.yandex.travel.api.models.common.Price
import ru.yandex.travel.commons.proto.ProtoUtils
import ru.yandex.travel.hotels.extranet.TBankOrderInfo
import java.time.LocalDate

data class BankOrderInfo(
    val paymentBatchId: String?,

    val bankOrderId: String,

    val status: String?,
    val sum: Price?,
    val description: String?,
    val eventTime: LocalDate?,
    val details: List<BankOrderInfoDetail>?,
) {
    companion object {
        fun fromProto(proto: TBankOrderInfo): BankOrderInfo {
            return BankOrderInfo(
                paymentBatchId = proto.paymentBatchId,
                bankOrderId = proto.bankOrderId,
                status = proto.status,
                sum = Price(proto.sum, Price.Currency.RUB),
                description = proto.description,
                eventTime = ProtoUtils.toLocalDateNullable(proto.eventTime),
                details = proto.detailsList.map { BankOrderInfoDetail.fromProto(it) },
            )
        }

        fun fromProtoForOrdersService(proto: TBankOrderInfo): BankOrderInfo {
            return BankOrderInfo(
                paymentBatchId = null,
                bankOrderId = proto.bankOrderId,
                status = null,
                sum = null,
                description = null,
                eventTime = null,
                details = null,
            )
        }
    }
}
