package ru.yandex.travel.api.endpoints.hotels_extranet.tabledata.req_rsp

import ru.yandex.travel.commons.proto.ProtoUtils
import ru.yandex.travel.hotels.extranet.EBankOrderTransactionPaymentType
import ru.yandex.travel.hotels.extranet.EBankOrderTransactionTransactionType
import ru.yandex.travel.hotels.extranet.TBankOrderInfoDetail
import java.time.Instant

data class BankOrderInfoDetail(
    val sum: String,

    val handlingTime: Instant,
    val paymentTime: Instant,

    val paymentType: EBankOrderTransactionPaymentType,
    val transactionType: EBankOrderTransactionTransactionType,

    val ytId: Long,
) {
    companion object {
        fun fromProto(proto: TBankOrderInfoDetail) : BankOrderInfoDetail {
            return BankOrderInfoDetail(
                sum = proto.sum,
                handlingTime = ProtoUtils.toInstant(proto.handlingTime),
                paymentTime = ProtoUtils.toInstant(proto.paymentTime),
                paymentType = proto.paymentType,
                transactionType = proto.transactionType,
                ytId = proto.ytId
            )
        }
    }
}
