package ru.yandex.travel.api.endpoints.hotels_extranet.tabledata.req_rsp

import ru.yandex.travel.api.models.common.Price
import ru.yandex.travel.commons.proto.ProtoUtils
import ru.yandex.travel.hotels.common.orders.Guest
import ru.yandex.travel.hotels.extranet.EExtranetOrderStatus
import ru.yandex.travel.hotels.extranet.TBoYOrderInfo
import ru.yandex.travel.hotels.extranet.TPriceBreakdown
import java.time.Instant
import java.time.LocalDate

data class BoyOrderInfo(
    val id: String,
    val prettyId: String,
    val partnerOrderId: String,
    val firstGuest: Guest,
    val status: EExtranetOrderStatus,
    val statusLocalized: String?,
    val createdAt: Instant,
    val updatedAt: Instant,
    val cancelledAt: Instant?,
    val checkInDate: LocalDate?,
    val checkOutDate: LocalDate?,
    val priceBreakdown: PriceBreakdown,
    val bankOrderInfo: Collection<BankOrderInfo>,
) {
    data class PriceBreakdown(
        val hotelPrice: Price?,
        val fiscalPrice: Price?,
        val discount: Price?,
        val fee: Price?,
        val partner: Price?,
        val paidAmount: Price?,
        val payoutAt: Instant?,
    ) {

        companion object {
            fun fromProto(proto: TPriceBreakdown): PriceBreakdown {
                return PriceBreakdown(
                    Price.fromProto(proto.hotelPrice),
                    Price.fromProto(proto.fiscalPrice),
                    Price.fromProto(proto.discount),
                    Price.fromProto(proto.fee),
                    Price.fromProto(proto.partner),
                    Price.fromProto(proto.paidAmount),
                    ProtoUtils.toInstant(proto.payoutAt),
                )
            }
        }
    }

    companion object {
        fun fromProto(proto: TBoYOrderInfo): BoyOrderInfo {
            val firstGuest = Guest()
            firstGuest.firstName = proto.firstGuest.firstName
            firstGuest.lastName = proto.firstGuest.lastName
            return BoyOrderInfo(
                proto.id,
                proto.prettyId,
                proto.partnerOrderId,
                firstGuest,
                proto.status,
                proto.statusLocalized,
                ProtoUtils.toInstant(proto.createdAt),
                ProtoUtils.toInstant(proto.updatedAt),
                if (proto.hasCancellationDateTime()) ProtoUtils.toInstant(proto.updatedAt) else null,
                ProtoUtils.toLocalDateNullable(proto.checkInDate),
                ProtoUtils.toLocalDateNullable(proto.checkOutDate),
                PriceBreakdown.fromProto(proto.priceBreakdown),
                if (proto.bankOrderInfoCount > 0)
                    proto.bankOrderInfoList.map { BankOrderInfo.fromProtoForOrdersService(it) }
                else emptyList()
            )
        }
    }
}
