package ru.yandex.travel.api.endpoints.hotels_extranet.tabledata.req_rsp

import ru.yandex.travel.commons.proto.ProtoUtils
import ru.yandex.travel.hotels.extranet.TDateIntervalFilter
import java.time.LocalDate

data class DateIntervalFilter(
    private val from: LocalDate?,
    private val till: LocalDate?
) {
    fun toProto(): TDateIntervalFilter {
        val builder = TDateIntervalFilter.newBuilder()
        from?.let { builder.from = ProtoUtils.toTDate(it) }
        till?.let { builder.till = ProtoUtils.toTDate(it) }
        return builder.build()
    }
}
