package ru.yandex.travel.api.endpoints.hotels_extranet.tabledata.req_rsp

import ru.yandex.travel.api.models.common.Price
import ru.yandex.travel.hotels.extranet.TGetBankOrderDetailsRsp
import java.math.BigDecimal

data class GetBankOrderDetailsRspV1(val result: List<BankOrderDetail>) {
    val sum: Price
        get() = Price(
            result.map { it.priceBreakdown.partner!!.value }
                .map { BigDecimal(it) }
                .fold(BigDecimal.ZERO, BigDecimal::add)
                .toString(),
            Price.Currency.RUB
        )

    companion object {
        fun fromProto(proto: TGetBankOrderDetailsRsp): GetBankOrderDetailsRspV1 {
            return GetBankOrderDetailsRspV1(
                proto.resultList.map { BankOrderDetail.fromProto(it) }.toList()
            )
        }
    }
}
