package ru.yandex.travel.api.endpoints.hotels_extranet.tabledata.req_rsp

import ru.yandex.travel.hotels.extranet.TGetBankOrderInfoReq
import ru.yandex.travel.hotels.proto.EPartnerId
import ru.yandex.travel.hotels.proto.THotelId
import javax.validation.constraints.NotBlank

data class GetBankOrdersReqV1(
    private val originalId: @NotBlank String,
    private val partnerId: EPartnerId,
    private val eventTime: DateIntervalFilter?,
    private val page: Page
) {
    fun toProto(): TGetBankOrderInfoReq {
        val builder = TGetBankOrderInfoReq.newBuilder()
        builder.hotelId = THotelId.newBuilder()
            .setPartnerId(partnerId)
            .setOriginalId(originalId)
            .build()
        page.let { builder.page = it.toProto() }
        eventTime?.let {
            builder.eventTime = it.toProto()
        }
        return builder.build()
    }
}
