package ru.yandex.travel.api.endpoints.hotels_extranet.tabledata.req_rsp

import ru.yandex.travel.api.endpoints.hotels_extranet.common.Hotel
import ru.yandex.travel.api.services.hotels.slug.HotelSlugService
import ru.yandex.travel.hotels.extranet.TGetBankOrderInfoRsp
import java.math.BigDecimal

data class GetBankOrdersRspV1(
    val totalRecords: Long,
    val hotelInfo: Hotel,
    val result: List<BankOrderInfo>
) {
    val sum: String
        get() = result.map {
            it.sum!!.value
        }.map {
            BigDecimal(it)
        }.fold(BigDecimal.ZERO, BigDecimal::add)
            .toString()

    companion object {
        fun fromProto(proto: TGetBankOrderInfoRsp, slugService: HotelSlugService): GetBankOrdersRspV1 {
            return GetBankOrdersRspV1(
                proto.totalRecords,
                Hotel.fromProto(proto.hotelInfo, slugService)!!,
                proto.resultList.map { BankOrderInfo.fromProto(it) }.toList()
            )
        }
    }
}
