package ru.yandex.travel.api.endpoints.hotels_extranet.tabledata.req_rsp

import ru.yandex.travel.hotels.extranet.EExtranetOrderStatus
import ru.yandex.travel.hotels.extranet.TGetOrdersReq
import ru.yandex.travel.hotels.proto.EPartnerId
import ru.yandex.travel.hotels.proto.THotelId
import javax.validation.constraints.NotBlank

data class GetOrdersReqV1(
    private val originalId: @NotBlank String,
    private val partnerId: EPartnerId,
    private val checkInDate: DateIntervalFilter?,
    private val checkOutDate: DateIntervalFilter?,
    private val orderedAt: DateIntervalFilter?,
    private val cancelledAt: DateIntervalFilter?,
    private val orderStatus: List<EExtranetOrderStatus>?,
    private val page: Page,
    private val sortFields: List<SortField>?,
) {
    fun toProto(): TGetOrdersReq {
        val builder = TGetOrdersReq.newBuilder()
        builder.hotelId = THotelId.newBuilder()
            .setPartnerId(partnerId)
            .setOriginalId(originalId)
            .build()
        checkInDate?.let { builder.checkInDate = it.toProto() }
        checkOutDate?.let { builder.checkOutDate = it.toProto() }
        orderedAt?.let { builder.orderedAt = it.toProto() }
        cancelledAt?.let { builder.cancelledAt = it.toProto() }
        orderStatus?.forEach(builder::addOrderStatus)
        page.let { builder.page = it.toProto() }
        sortFields?.map { it.toProto() }.let { it?.forEach(builder::addSort) }
        return builder.build()
    }
}
