package ru.yandex.travel.api.endpoints.hotels_extranet.tabledata.req_rsp

import ru.yandex.travel.api.endpoints.hotels_extranet.common.Hotel
import ru.yandex.travel.api.models.common.Price
import ru.yandex.travel.api.services.hotels.slug.HotelSlugService
import ru.yandex.travel.hotels.extranet.TGetOrdersRsp

data class GetOrdersRspV1(
    val totalRecords: Long,
    val hotelInfo: Hotel,
    val result: List<BoyOrderInfo>,
    val feeSum: Price,
    val partnerSum: Price,
    val fiscalSum: Price,
    val paidSum: Price,
) {

    companion object {
        fun fromProto(proto: TGetOrdersRsp, slugService: HotelSlugService): GetOrdersRspV1 {
            val resultList = proto.resultList
            return GetOrdersRspV1(
                proto.totalRecords,
                Hotel.fromProto(proto.hotelInfo, slugService)!!,
                resultList.map { BoyOrderInfo.fromProto(it) }.toList(),
                Price.fromProto(proto.feeSum) ?: Price.ZERO,
                Price.fromProto(proto.partnerSum) ?: Price.ZERO,
                Price.fromProto(proto.fiscalSum) ?: Price.ZERO,
                Price.fromProto(proto.paidSum) ?: Price.ZERO
            )
        }
    }
}
