package ru.yandex.travel.api.endpoints.hotels_portal;

import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.travel.hotels.proto.EPartnerId;

@Data
public class AdditionalSearchHotelsLogData {
    public enum UserSegmentType {
        UNKNOWN,
        NO_VALUE,
        WEIGHTED,
    }

    @Data
    @AllArgsConstructor
    public static class UserSegment {
        private String keywordId;
        private String keywordName;
        private String segmentId;
        private String segmentName;
        private UserSegmentType segmentType;
        private Integer weight;
    }

    @Data
    @AllArgsConstructor
    public static class UserSegmentsInfo {
        private List<UserSegment> segments;
    }

    @Data
    @AllArgsConstructor
    public static class HotelRealTimeRankingInfo {
        private long permalink;
        private boolean catBoostUsed;
        private Double catBoostPrediction;
    }

    @Data
    @AllArgsConstructor
    public static class RealTimeRankingInfo {
        private List<HotelRealTimeRankingInfo> hotelInfos;
    }

    private boolean hasOfferCacheMeta;
    private List<EPartnerId> finishedPartners;
    private List<EPartnerId> pendingPartners;
    private UserSegmentsInfo userSegmentsInfo;
    private RealTimeRankingInfo realTimeRankingInfo;
}
