package ru.yandex.travel.api.endpoints.hotels_portal;

import ru.yandex.travel.api.models.hotels.Badge;
import ru.yandex.travel.hotels.offercache.api.EBadgeTheme;
import ru.yandex.travel.hotels.offercache.api.TBadge;
import ru.yandex.travel.hotels.proto.geocounter_service.TGetHotelsResponse;

public class BadgeUtils {
    public static Badge extractBadge(TBadge protoBadge) {
        var builder = Badge.builder()
                .id(protoBadge.getId())
                .text(protoBadge.getText())
                .theme(mapTheme(protoBadge.getTheme()));
        if (protoBadge.hasAdditionalInfo()) {
            builder.additionalPromoInfo(getAdditionalPromoInfo(protoBadge.getAdditionalInfo()));
        }
        return builder.build();
    }

    public static Badge extractBadge(TGetHotelsResponse.THotelBadge protoBadge) {
        var builder = Badge.builder()
                .id(protoBadge.getId())
                .text(protoBadge.getText())
                .theme(mapTheme(protoBadge.getTheme()));
        if (protoBadge.hasAdditionalInfo()) {
            builder.additionalPromoInfo(getAdditionalPromoInfo(protoBadge.getAdditionalInfo()));
        }
        return builder.build();
    }

    private static Badge.AdditionalPromoInfo getAdditionalPromoInfo(TBadge.TAdditionalInfo additionalInfo) {
        var builder = Badge.AdditionalPromoInfo.builder()
                .title(additionalInfo.getTitle())
                .text(additionalInfo.getText());
        if (additionalInfo.hasLink()) {
            builder.link(Badge.Link.builder()
                    .text(additionalInfo.getLink().getText())
                    .url(additionalInfo.getLink().getUrl())
                    .build());
        }
        return builder.build();
    }

    private static Badge.BadgeTheme mapTheme(EBadgeTheme theme) {
        return Badge.BadgeTheme.map(theme);
    }
}
