package ru.yandex.travel.api.endpoints.hotels_portal;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.travel.api.models.hotels.interfaces.RequestAttributionProvider;

public class Experiments {
    private Map<String, String> values;

    private Experiments() {
        values = new HashMap<>();
    }

    public static Experiments createEmpty() {
        return new Experiments();
    }

    public Experiments(RequestAttributionProvider attr, HotelsPortalProperties config) {
        values = new HashMap<>();
        for (String expId: config.getForceEnableExp()) {
            values.put(expId, "1");
        }
        if (attr != null && attr.getUtmTerm() != null) {
            for (String token: attr.getUtmTerm().split(",")) {
                var parts = token.split(":", 2);
                if (!token.contains(":") && token.contains("|")) {
                    parts = token.split("\\|", 2);
                }
                values.put(parts[0], parts.length > 1 ? parts[1] : "1");
            }
        }
        for (String expId: config.getForceDisableExp()) {
            values.remove(expId);
        }
    }

    public boolean isExp(String key) {
        String value = getValue(key);
        return value != null && !"0".equals(value);
    }

    public String getValue(String key) {
        return values.get(key);
    }

    public Integer getIntValue(String key) {
        try {
            return Integer.parseInt(getValue(key));
        } catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return values.toString();
    }
}
