package ru.yandex.travel.api.endpoints.hotels_portal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.validation.constraints.NotNull;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Data
@ConfigurationProperties(value = "hotels-portal", ignoreUnknownFields = false)
@Validated
public class HotelsPortalProperties {
    private List<String> experiments;
    private boolean reversePaths;
    private boolean enableDebugParams;

    private double bboxMoveMaxSquareRatio;
    private double bboxMoveMinSquareRatio;
    private double bboxMoveMaxRelativeDistance;

    @Data
    public static class HotelRatingConfig {
        private String teaserTextTemplate;
        private String ratingText;
        private List<String> forAmenity;
    }

    @Data
    public static class PollingDelays {
        private boolean expDecay = true;
        private int baseDelayMs = 1000;
        private int maxDelayMs = 60000;
        private int maxIteration = 10;
        private double lambda = 2;

        private int fallbackDelayMs = 2000;
    }

    private Map<String, HotelRatingConfig> ratings = new HashMap<>();

    private boolean useGeoBbox;
    private boolean sortOffersUsingPlus;

    private Map<String, Integer> hotelBadgePriorities = new HashMap<>(); // 0 is magic, means badge is not allowed
    private Map<String, Integer> offerBadgePriorities = new HashMap<>(); // 0 is magic, means badge is not allowed

    @NotNull
    private String searchPrefix;

    private List<String> filterLayoutTags = new ArrayList<>();

    private List<String> forceEnableExp = new ArrayList<>();
    private List<String> forceDisableExp = new ArrayList<>();

    private List<String> hotelCategoriesToSearch = new ArrayList<>();
    private List<String> hotelCategoriesToShow = new ArrayList<>();

    private Set<String> bannedPermalinksToShow = new HashSet<>();

    private Map<String, String> geosearchParams = new HashMap<>();

    // Ugc offset limit. Ugc send 400 when offset is big
    @NotNull
    private int maxTextReviewOffset;

    private boolean allowNewSearch;

    private boolean allowNoSearchParamsInHotelInfo;

    private boolean renameDoubleSuggestDescription;
    private int maxPermalinksToVisitParams = 25;

    private int maxMainAmenities = 4;

    private boolean showNearestStationOnSnippet = false; // Disabled here https://st.yandex-team.ru/HOTELS-5639#61712d418a51f038067bcf04

    private PollingDelays pollingDelays = new PollingDelays();

    private boolean showHotelDirectBanner = false;

    private boolean prodToursLabelEnvironment = false;

    private int plusDefaultPercentDiscount = 10;

    private boolean regionStaticPageEnabled = true;

    private boolean calendarPricesEnabled = false;

    private boolean fakeCatBoostRanking = false;
}
