package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.infrastucture.ParamName;
import ru.yandex.travel.hotels.common.Permalink;

@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@ApiModel(value = "Добавление отеля в избранное")
public class AddFavoriteHotelReqV1 extends RequestAttributionProviderImpl {
    @ParamName("domain")
    @ApiParam(name = "domain", value = "Геополитический домен")
    @NotNull
    private String domain = "ru";

    @ParamName("permalink")
    @ApiParam(name = "permalink", value = "Hotel Permalink")
    @NotNull
    private Permalink permalink;
}
