package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import java.time.LocalDate;
import java.util.List;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import ru.yandex.travel.api.infrastucture.ParamName;
import ru.yandex.travel.api.models.hotels.BoundingBox;
import ru.yandex.travel.api.models.hotels.Coordinates;
import ru.yandex.travel.api.models.hotels.interfaces.OfferSearchParamsProvider;
import ru.yandex.travel.api.models.hotels.interfaces.SearchFilterParamsProvider;
import ru.yandex.travel.api.models.hotels.interfaces.SearchSortParamsProvider;
import ru.yandex.travel.hotels.common.Ages;

@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@ApiModel(value = "Запрос количества отелей после фильтрации")
public class CountHotelsReqV1
        extends RequestAttributionProviderImpl
        implements OfferSearchParamsProvider, SearchFilterParamsProvider, SearchSortParamsProvider {

    // OfferSearchParamsProvider
    @ParamName("checkin_date")
    @ApiParam(name = "checkin_date", value = "Дата заселения", required = true)
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    @NotNull
    private LocalDate checkinDate;

    @ParamName("checkout_date")
    @ApiParam(name = "checkout_date", value = "Дата выселения", required = true)
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    @NotNull
    private LocalDate checkoutDate;

    @ParamName("adults")
    @ApiParam(name = "adults", value = "Количество взрослых гостей")
    @Min(Ages.MIN_ADULTS)
    @Max(Ages.MAX_ADULTS)
    @NotNull
    private Integer adults = 2;

    @ParamName("children_ages")
    @ApiParam(name = "children_ages", value = "Возраста детей")
    private List<@Min(Ages.MIN_CHILD_AGE) @Max(Ages.MAX_CHILD_AGE) Integer> childrenAges;

    // HotelCountParamsProvider
    @NotNull
    @ParamName("bbox")
    @ApiParam(name = "bbox", value = "Bounding box", required = true)
    private BoundingBox bbox;

    // SearchFilterParamsProvider
    @ParamName("filter_atoms")
    @ApiParam(name = "filter_atoms", value = "Filter atoms")
    private List<String> filterAtoms;

    @ParamName("filter_price_from")
    @ApiParam(name = "filter_price_from", value = "Filter price from")
    private Integer filterPriceFrom;

    @ParamName("filter_price_to")
    @ApiParam(name = "filter_price_to", value = "Filter price to")
    private Integer filterPriceTo;

    @ParamName("only_current_geo_id")
    @ApiParam(name = "only_current_geo_id", value = "Фильтрация отелей по заданному GeoId")
    private boolean onlyCurrentGeoId = true;

    // SearchSortParamsProvider
    @ParamName("selected_sort_id")
    @ApiParam(name = "selected_sort_id", value = "Id выбранного типа сортировки")
    private String selectedSortId;

    @ParamName("sort_origin")
    @ApiParam(name = "sort_origin", value = "Центр сортировки")
    private Coordinates sortOrigin;

    @ParamName("force_filters_layout")
    @ApiParam(name = "force_filters_layout", value = "Конфигурация фильтров, которую нужно использовать вместо варианта по умолчанию. Только для дебага")
    private String forceFiltersLayout = null;
}
