package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import ru.yandex.travel.api.infrastucture.ParamName;
import ru.yandex.travel.api.models.hotels.interfaces.HotelIdentifierProvider;
import ru.yandex.travel.hotels.common.Permalink;

@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@ApiModel(value = "Удаление отзыва в ugc")
public class DeleteHotelReviewReqV1
        extends RequestAttributionProviderImpl
        implements HotelIdentifierProvider {

    // HotelIdentifierProvider
    @ParamName("permalink")
    @ApiParam(name = "permalink", value = "Hotel Permalink")
    private Permalink permalink;

    @ParamName("hotel_slug")
    @ApiParam(name = "hotel_slug", value = "Hotel Slug")
    private String hotelSlug;

    // HotelTestableUgcProvider
    @ParamName("enabled_test_ugc")
    @ApiParam(name = "enabled_test_ugc", value = "Enable testing for UGC")
    public boolean enabledTestUgc = false;

    //Own
    @ParamName("review_id")
    @ApiParam(name = "review_id", value = "Review ID")
    @NotNull
    @NotBlank
    private String reviewId;
}
