package ru.yandex.travel.api.endpoints.hotels_portal.req_rsp;

import java.time.LocalDate;
import java.util.List;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import ru.yandex.travel.api.infrastucture.ParamName;
import ru.yandex.travel.api.models.hotels.interfaces.SearchContextWithAttribution;
import ru.yandex.travel.hotels.common.Ages;
import ru.yandex.travel.hotels.common.Permalink;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "Запрос календаря цен для отеля")
public class GetCalendarPricesReqV1 extends RequestAttributionProviderImpl implements SearchContextWithAttribution {
    @ParamName("start_date")
    @ApiParam(name = "start_date", value = "Первая дата в календаре")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    @NotNull
    private LocalDate startDate;

    @ParamName("end_date")
    @ApiParam(name = "end_date", value = "Последняя дата в календаре")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    @NotNull
    private LocalDate endDate;

    @ParamName("context")
    @ApiParam(name = "context", value = "Контекст поиска")
    private String context;

    // OfferSearchParamsProvider
    @ParamName("checkin_date")
    @ApiParam(name = "checkin_date", value = "Дата заселения")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    private LocalDate checkinDate;

    @ParamName("checkout_date")
    @ApiParam(name = "checkout_date", value = "Дата выселения")
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    private LocalDate checkoutDate;

    @ParamName("adults")
    @ApiParam(name = "adults", value = "Количество взрослых гостей")
    @Min(Ages.MIN_ADULTS)
    @Max(Ages.MAX_ADULTS)
    @NotNull
    private Integer adults = 2;

    @ParamName("children_ages")
    @ApiParam(name = "children_ages", value = "Возраста детей")
    private List<@Min(Ages.MIN_CHILD_AGE) @Max(Ages.MAX_CHILD_AGE) Integer> childrenAges;

    // DebugOfferSearchParamsProvider
    @ParamName("debug_portal_host")
    @ApiParam(name = "debug_portal_host")
    private String debugPortalHost;

    @ParamName("debug_use_prod_offers")
    @ApiParam(name = "debug_use_prod_offers")
    private boolean debugUseProdOffers = false;

    // HotelIdentifierProvider
    @ParamName("permalink")
    @ApiParam(name = "permalink", value = "Hotel Permalink")
    private Permalink permalink;

    @ParamName("hotel_slug")
    @ApiParam(name = "hotel_slug", value = "Hotel Slug")
    private String hotelSlug;
}
